/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;

abstract class ConfigEntry
implements MouseListener {
    private String name;
    private String desc;
    private boolean invalid;
    private boolean viewable;
    private boolean editable;
    private boolean outputOnChange;
    private PrintStream output;
    protected Component label;
    protected Component field;

    public ConfigEntry() {
        this.name = "";
        this.desc = "";
        this.invalid = false;
        this.viewable = true;
        this.editable = true;
        this.outputOnChange = false;
        this.output = System.out;
    }

    public ConfigEntry(String string, String string2) {
        this.name = string;
        this.setDesc(string2);
        this.invalid = false;
        this.viewable = true;
        this.editable = true;
        this.outputOnChange = false;
        this.output = System.out;
    }

    public ConfigEntry(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.setDesc(string2);
        this.invalid = bl;
        this.viewable = bl2;
        this.editable = bl3;
        this.outputOnChange = false;
        this.output = System.out;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setField(Component component) {
        this.field = component;
        this.field.addMouseListener(this);
    }

    public void setLabel(Component component) {
        this.label = component;
        this.label.addMouseListener(this);
    }

    public void setDesc(String string) {
        this.desc = string;
        this.setLabel(new Label(this.desc + ":", 2));
    }

    public void setOutput(PrintStream printStream) {
        this.output = printStream;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isOutputOnChange() {
        return this.outputOnChange;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public abstract boolean setValueFromInputStream(String var1);

    public void addToTwiddler(Twiddler twiddler) {
        if (!this.isViewable()) {
            return;
        }
        if (!this.isEditable()) {
            this.field.setEnabled(false);
            this.field.setBackground(Color.white);
        }
        if (this.label != null) {
            twiddler.add(this.label);
        } else {
            twiddler.add(new Label());
        }
        if (this.field != null) {
            twiddler.add(this.field);
        } else {
            twiddler.add(new Label());
        }
        ++twiddler.numControls;
    }

    public void doPrint() {
        this.doPrint(this.output);
    }

    public void doPrint(PrintStream printStream) {
        printStream.print("set " + this.name + " = ");
        this.doSpecificPrint(printStream);
        printStream.println();
        printStream.flush();
    }

    public abstract void doSpecificPrint(PrintStream var1);

    public static String[] readLineWords(BufferedReader bufferedReader, int n) throws IOException {
        String string = bufferedReader.readLine().trim();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("[ \t]+", n);
        return stringArray;
    }

    public static String[] readLineWords(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("[ \t]+");
        return stringArray;
    }

    public static String readString(BufferedReader bufferedReader, String string) throws IOException {
        String[] stringArray = ConfigEntry.readLineWords(bufferedReader, 2);
        if (!stringArray[0].equals(string)) {
            System.err.println("Expected \"" + string + "\" keyword, found \"" + stringArray[0] + "\"");
            System.exit(1);
        }
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return "";
    }

    public static void readKeyword(BufferedReader bufferedReader, String string) throws IOException {
        ConfigEntry.readString(bufferedReader, string);
    }

    public static boolean readBool(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = ConfigEntry.readString(bufferedReader, string).toLowerCase();
        return string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y");
    }

    public static boolean readBoolean(BufferedReader bufferedReader, String string) throws IOException {
        return ConfigEntry.readBool(bufferedReader, string);
    }

    public static double readDouble(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = ConfigEntry.readString(bufferedReader, string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Expected double value, found \"" + string2 + "\"");
            System.exit(1);
            return 0.0;
        }
    }

    public static long readLong(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = ConfigEntry.readString(bufferedReader, string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Expected long value, found \"" + string2 + "\"");
            System.exit(1);
            return 0L;
        }
    }

    public void readDefinition(BufferedReader bufferedReader) throws IOException {
        this.setName(ConfigEntry.readString(bufferedReader, "name"));
        this.setDesc(ConfigEntry.readString(bufferedReader, "desc"));
        this.invalid = ConfigEntry.readBool(bufferedReader, "invalid");
        this.viewable = ConfigEntry.readBool(bufferedReader, "viewable");
        this.editable = ConfigEntry.readBool(bufferedReader, "editable");
        this.outputOnChange = ConfigEntry.readBool(bufferedReader, "outputOnChange");
        this.readDefinitionSpecific(bufferedReader);
        ConfigEntry.readKeyword(bufferedReader, "end");
    }

    public abstract void readDefinitionSpecific(BufferedReader var1) throws IOException;

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.label instanceof Label) {
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.label instanceof Label) {
            this.label.setFont(this.label.getFont().deriveFont(0));
        }
    }
}

